#include "rtcrypta_solomon_utils_factory.h"

#include <crypta/lib/native/cmd_args/parse_pb_options.h>
#include <crypta/lib/native/rtmr/rtcrypta_solomon_utils/lib/errors_to_solomon_metrics_mapper/errors_to_solomon_metrics_mapper.h>
#include <crypta/lib/native/rtmr/rtcrypta_solomon_utils/lib/solomon_metrics_reducer/solomon_metrics_reducer.h>

#include <rtmapreduce/libs/mapreduce-yt/operation.h>

using namespace NCrypta;

NRTMR::NTask::TOperationPtr TRtCryptaSolomonUtilsFactory::CreateOperation(const TString& name, const NRTMR::NTask::TTaskContextPtr& context) {
    if (name == "solomon_metrics_reducer") {
        return NRTMR::NTask::NewOperation<NCrypta::TSolomonMetricsReducer>();
    } else if (name == "errors_to_solomon_metrics_mapper") {
        const auto& config = ParsePbOptions<TErrorsToSolomonMetricsMapperConfig>(context->GetArgc(), context->GetArgv());
        return NRTMR::NTask::NewOperation<NCrypta::TErrorsToSolomonMetricsMapper>(config);
    }

    return nullptr;
};
