#include "sensors_registry_merger.h"

using namespace NCrypta;

TSensorsRegistryMerger::TSensorsRegistryMerger(NMonitoring::TMetricRegistry& registry)
    : Registry(registry) {
}

void TSensorsRegistryMerger::OnStreamBegin() {
}

void TSensorsRegistryMerger::OnStreamEnd() {
}

void TSensorsRegistryMerger::OnCommonTime(TInstant time) {
    Y_UNUSED(time);
}

void TSensorsRegistryMerger::OnMetricBegin(NMonitoring::EMetricType kind) {
    InSensor = true;
    MetricType = kind;
}

void TSensorsRegistryMerger::OnMetricEnd() {
    for (const auto& label: CommonLabels) {
        Labels.Add(label);
    }

    if (MetricType == NMonitoring::EMetricType::GAUGE) {
        Registry.Gauge(Labels)->Add(std::get<double>(*Value));
    } else if (MetricType == NMonitoring::EMetricType::IGAUGE) {
        Registry.IntGauge(Labels)->Add(std::get<i64>(*Value));
    } else if (MetricType == NMonitoring::EMetricType::COUNTER) {
        Registry.Counter(Labels)->Add(std::get<ui64>(*Value));
    } else if (MetricType == NMonitoring::EMetricType::RATE) {
        Registry.Rate(Labels)->Add(std::get<ui64>(*Value));
    } else if (MetricType == NMonitoring::EMetricType::HIST || MetricType == NMonitoring::EMetricType::HIST_RATE) {
        NMonitoring::TBucketBounds bucketBounds;
        auto snapshot = std::get<NMonitoring::IHistogramSnapshotPtr>(*Value);

        for (ui32 i = 0; i < snapshot->Count() - 1; ++i) {
            bucketBounds.emplace_back(snapshot->UpperBound(i));
        }
        auto collector = NMonitoring::ExplicitHistogram(bucketBounds);
        NMonitoring::THistogram* hist = (MetricType == NMonitoring::EMetricType::HIST) ? Registry.HistogramCounter(Labels, std::move(collector)) : Registry.HistogramRate(Labels, std::move(collector));

        for (ui32 i = 0; i < snapshot->Count(); ++i) {
            hist->Record(snapshot->UpperBound(i), snapshot->Value(i));
        }
    }
}

void TSensorsRegistryMerger::OnLabelsBegin() {
    Labels.Clear();
}

void TSensorsRegistryMerger::OnLabelsEnd() {
    if (!InSensor) {
        CommonLabels = Labels;
    }
}

void TSensorsRegistryMerger::OnLabel(const TStringBuf name, const TStringBuf value) {
    Labels.Add(name, value);
}

void TSensorsRegistryMerger::OnDouble(TInstant time, double value) {
    Y_UNUSED(time);
    Value = value;

}

void TSensorsRegistryMerger::OnInt64(TInstant time, i64 value) {
    Y_UNUSED(time);
    Value = value;
}

void TSensorsRegistryMerger::OnUint64(TInstant time, ui64 value) {
    Y_UNUSED(time);
    Value = value;
}

void TSensorsRegistryMerger::OnHistogram(TInstant time, NMonitoring::IHistogramSnapshotPtr snapshot) {
    Y_UNUSED(time);
    Value = snapshot;
}

void TSensorsRegistryMerger::OnSummaryDouble(TInstant, NMonitoring::ISummaryDoubleSnapshotPtr snapshot) {
    Value = snapshot;
}

void TSensorsRegistryMerger::OnLogHistogram(TInstant, NMonitoring::TLogHistogramSnapshotPtr snapshot) {
    Value = snapshot;
}


