#pragma once

#include <library/cpp/monlib/metrics/metric_consumer.h>
#include <library/cpp/monlib/metrics/metric_registry.h>

#include <util/generic/maybe.h>
#include <util/generic/variant.h>

namespace NCrypta {
    class TSensorsRegistryMerger : public NMonitoring::IMetricConsumer {
    public:
        using TValue = std::variant<i64, ui64, double, NMonitoring::IHistogramSnapshotPtr, NMonitoring::ISummaryDoubleSnapshotPtr, NMonitoring::TLogHistogramSnapshotPtr>;

        TSensorsRegistryMerger(NMonitoring::TMetricRegistry& registry);

        ~TSensorsRegistryMerger() override = default;

        void OnStreamBegin() override;
        void OnStreamEnd() override;

        void OnCommonTime(TInstant time) override;

        void OnMetricBegin(NMonitoring::EMetricType kind) override;
        void OnMetricEnd() override;

        void OnLabelsBegin() override;
        void OnLabelsEnd() override;
        void OnLabel(const TStringBuf name, const TStringBuf value) override;

        void OnDouble(TInstant time, double value) override;
        void OnInt64(TInstant time, i64 value) override;
        void OnUint64(TInstant time, ui64 value) override;

        void OnHistogram(TInstant time, NMonitoring::IHistogramSnapshotPtr snapshot) override;
        void OnLogHistogram(TInstant, NMonitoring::TLogHistogramSnapshotPtr) override;
        void OnSummaryDouble(TInstant, NMonitoring::ISummaryDoubleSnapshotPtr) override;

    private:
        NMonitoring::TMetricRegistry& Registry;
        NMonitoring::EMetricType MetricType;
        NMonitoring::TLabels CommonLabels;
        NMonitoring::TLabels Labels;
        bool InSensor = false;
        TMaybe<TValue> Value;
    };
}
