#include "solomon_metrics_reducer.h"

#include <library/cpp/monlib/encode/json/json.h>

using namespace NCrypta;

void TSolomonMetricsReducer::ResetState() {
    SensorsRegistry.Reset(new NMonitoring::TMetricRegistry());
    Merger.Reset(new TSensorsRegistryMerger(*SensorsRegistry));
}

void TSolomonMetricsReducer::LoadState(IInputStream& in) {
    NMonitoring::DecodeJson(in.ReadAll(), Merger.Get());
}

void TSolomonMetricsReducer::SaveState(IOutputStream& out) const {
    auto encoder = NMonitoring::EncoderJson(&out);
    SensorsRegistry->Accept(Timestamp, encoder.Get());
}

void TSolomonMetricsReducer::Do(TReader* reader, TWriter* writer) {
    for (; reader->IsValid(); reader->Next()) {
        const auto& row = reader->GetRow();

        Key = row.Key;
        Timestamp = TInstant::Seconds(FromString(row.Key));

        NMonitoring::DecodeJson(row.Value, Merger.Get());
    }

    TStringStream ss;
    auto encoder = NMonitoring::EncoderJson(&ss);
    SensorsRegistry->Accept(Timestamp, encoder.Get());

    writer->AddRow({Key, "", ss.Str()});
}
