#pragma once

#include "sensors_registry_merger.h"

#include <library/cpp/monlib/metrics/metric_registry.h>
#include <rtmapreduce/libs/mapreduce-yt/operation.h>

namespace NCrypta {
    class TSolomonMetricsReducer : public NRTMR::NTask::IStatefulReducer<NYT::TYaMRReader, NYT::TYaMRWriter> {
    public:
        void ResetState() override;
        void LoadState(IInputStream& in) override;
        void SaveState(IOutputStream& in) const override;

        void Do(TReader* reader, TWriter* writer) override;

    private:
        THolder<NMonitoring::TMetricRegistry> SensorsRegistry;
        THolder<TSensorsRegistryMerger> Merger;
        TInstant Timestamp;
        TString Key;
    };
}
