#include "tskv_parser_mapper.h"

using namespace NYT;

namespace NCrypta {
    TTskvParserMapper::TParser::TParser()
        : TLogParser({})
        , TTskvLogParser({}) {
    }

    bool TTskvParserMapper::TParser::TryParse(const TStringBuf& rawRecord, NYT::TNode& parsedRecord)
    {
        try {
            ParseRaw(rawRecord, parsedRecord);
            return true;
        } catch (yexception& error) {
            return false;
        }
    }

    void TTskvParserMapper::Do(TReader* reader, TWriter* writer) {
        for (; reader->IsValid(); reader->Next()) {
            TNode parsed;

            if (Parser.TryParse(reader->GetRow().Value, parsed)) {
                DoParsed(parsed, writer);
            }
        }
    }
}
