#pragma once

#include <crypta/lib/native/singleton/tagged_singleton.h>

#include <logfeller/lib/log_parser/tskv_log_parser.h>
#include <mapreduce/yt/interface/operation.h>

namespace NCrypta {
    class TTskvParserMapper : public NYT::IMapper<NYT::TTableReader<NYT::TYaMRRow>, NYT::TTableWriter<NYT::TYaMRRow>> {
    public:
        void Do(TReader* reader, TWriter* writer) final;

    protected:
        virtual void DoParsed(const NYT::TNode& parsed, TWriter* writer) = 0;

        template <typename T>
        static T GetSafe(const NYT::TNode& node, const TString& key, const T& defaultValue = TaggedSingleton<T, TTskvParserMapper>()) {
            const auto& nodeMap = node.AsMap();
            const auto& it = nodeMap.find(key);

            return (it != nodeMap.end()) ? it->second.As<T>() : defaultValue;
        };

    private:
        class TParser: public NLogFeller::NLogParser::TTskvLogParser {
        public:
            TParser();
            bool TryParse(const TStringBuf& rawRecord, NYT::TNode& parsedRecord);
        };

        TParser Parser;
    };
}
