#pragma once

#include "rest_sampler.h"

#include <util/ysaveload.h>

namespace NCrypta {
    template <auto HashFunction>
    class THashSampler {
    public:
        THashSampler()
            : RestSampler(1, 0, TRestSampler::EMode::Equal)
        {
        }

        THashSampler(size_t denominator, size_t rest, TRestSampler::EMode mode)
            : RestSampler(denominator, rest, mode)
        {
        }

        template <typename TBuf>
        bool Passes(const TBuf& buf) const {
            return RestSampler.Passes(HashFunction(buf));
        }

        Y_SAVELOAD_DEFINE(RestSampler);

    private:
        TRestSampler RestSampler;
    };
}
