#pragma once

#include <stddef.h>

#include <util/ysaveload.h>

namespace NCrypta {
    class TRestSampler {
    public:
        enum class EMode {
            Equal,
            Less
        };

        TRestSampler(size_t denominator, size_t rest, EMode mode = EMode::Equal);

        template <typename TValue>
        bool Passes(TValue value) const {
            return Passes(value, Denominator, Rest, Mode);
        }

        template <typename TValue>
        static bool Passes(TValue value, size_t denominator, size_t rest, EMode mode = EMode::Equal) {
            if (mode == EMode::Equal) {
                return (value % denominator) == rest;
            } else if (mode == EMode::Less) {
                return (value % denominator) < rest;
            } else {
                ythrow yexception() << "Unexpected mode " << mode;
            }
        }

        Y_SAVELOAD_DEFINE(Denominator, Rest, Mode);

    private:
        size_t Denominator = 1;
        size_t Rest = 0;
        EMode Mode = EMode::Equal;
    };
}
