#include <crypta/lib/native/sampler/hash_sampler.h>

#include <library/cpp/testing/unittest/registar.h>

#include <util/digest/fnv.h>

namespace {
    inline uint64_t FnvHashFunc(const TStringBuf& buf) {
        return FnvHash<ui64, TStringBuf>(buf);
    }
}

Y_UNIT_TEST_SUITE(THashSampler) {
    using namespace NCrypta;

    Y_UNIT_TEST(TFnvHashSampler) {
        THashSampler<FnvHashFunc> sampler(100, 2, TRestSampler::EMode::Less);

        const TString dataNonPassing = "hash_mod_100_not_less_than_2__166";
        UNIT_ASSERT_EQUAL_C(5675169423469703502ULL, FnvHashFunc(dataNonPassing), FnvHashFunc(dataNonPassing));
        UNIT_ASSERT(!sampler.Passes(dataNonPassing));

        const TString dataPassing = "hash_mod_100_less_than_2__33";
        UNIT_ASSERT_EQUAL_C(18193871474103706601ULL, FnvHashFunc(dataPassing), FnvHashFunc(dataPassing));
        UNIT_ASSERT(sampler.Passes(dataPassing));
    }

    Y_UNIT_TEST(TFnvHashSamplerZero) {
        THashSampler<FnvHashFunc> sampler(100, 0, TRestSampler::EMode::Less);

        const TString dataWithZeroRest = "data_with_zero_rest__71";
        UNIT_ASSERT_EQUAL_C(6395977953360292100ULL, FnvHashFunc(dataWithZeroRest), FnvHashFunc(dataWithZeroRest));
        UNIT_ASSERT(!sampler.Passes(dataWithZeroRest));
    }
}
