#include <crypta/lib/native/sampler/rest_sampler.h>

#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(TRestSampler) {
    using namespace NCrypta;

    Y_UNIT_TEST(Equals) {
        UNIT_ASSERT(TRestSampler(1, 0).Passes(123));
        UNIT_ASSERT(TRestSampler(10, 3, TRestSampler::EMode::Equal).Passes(123));

        UNIT_ASSERT(!TRestSampler(10, 3, TRestSampler::EMode::Equal).Passes(121));
        UNIT_ASSERT(!TRestSampler(10, 3, TRestSampler::EMode::Equal).Passes(122));
    }

    Y_UNIT_TEST(Less) {
        UNIT_ASSERT(TRestSampler(10, 3, TRestSampler::EMode::Less).Passes(120));
        UNIT_ASSERT(TRestSampler(10, 3, TRestSampler::EMode::Less).Passes(121));
        UNIT_ASSERT(TRestSampler(10, 3, TRestSampler::EMode::Less).Passes(122));

        UNIT_ASSERT(!TRestSampler(10, 3, TRestSampler::EMode::Less).Passes(123));
    }

    Y_UNIT_TEST(Negative) {
        UNIT_ASSERT_EXCEPTION(TRestSampler(0, 0).Passes(123), yexception);
        UNIT_ASSERT_EXCEPTION(TRestSampler(10, 11).Passes(123), yexception);
    }
}
