#include "signal_waiter.h"

#include <library/cpp/sighandler/async_signals_handler.h>

using namespace NCrypta;

TSignalWaiter::TSignalWaiter(const TVector<int>& signals) {
    Y_ENSURE(!signals.empty(), "Signals list is empty");

    auto stopHandler = [this](int) { Event.Signal(); };

    for (const auto signal : signals) {
        SetAsyncSignalFunction(signal, stopHandler);
    }
}

void TSignalWaiter::Wait() {
    Event.Wait();
}

void TSignalWaiter::Signal() {
    Event.Signal();
}
