#pragma once

#include <utility>

namespace NCrypta {
    // NOTE: args are used for the first initialization only!
    // So TaggedSingleton<T>(args1) == TaggedSingleton<T>(args2)
    /**
     * @brief Returns reference instance of type T
     * @param args - ctor arguments that are used for the first initialization only.
     * So Singleton<T>(args1) == Singleton<T>(args2) == T(args1).
     */
    template <typename T, typename TTag = void, typename... TArgs>
    T& TaggedSingleton(TArgs&&... args) {
        static T instance(std::forward<TArgs>(args)...);
        return instance;
    }

    template <typename T, typename TTag = void>
    T& TaggedSingleton() {
        static T instance;
        return instance;
    }
}
