#include "solomon_data_client.h"

#include <crypta/lib/native/url/url_utils.h>
#include <library/cpp/http/client/query.h>

#include <util/generic/strbuf.h>
#include <util/string/builder.h>

using namespace NCrypta;

TSolomonDataClient::TSolomonDataClient(
    const TString& schema,
    const TString& host,
    const ui32 port,
    const TString& oauthToken,
    TDuration requestTimeout,
    const TString& project)
    : Url(NCrypta::NUrlUtils::MakeUrl(schema, host, port,
                                      TStringBuilder() << "/api/v2" << "/projects/" << project << "/sensors/data"))
    , OAuthToken(oauthToken)
    , RequestTimeout(requestTimeout)
{
}
