#pragma once

#include <crypta/lib/python/native_yt/cpp/proto.h>

using NNativeYT::TProtoState;

template <class T, class P>
class TStateful: public P {
public:
    TStateful()
        : State()
    {
    }

    TStateful(const TBuffer& buffer)
        : State(buffer)
    {
    }

    void Save(IOutputStream& output) const {
        State.Save(output);
    }

    void Load(IInputStream& input) {
        State.Load(input);
    }

protected:
    TProtoState<T> State;
};
