#include "avg_stat.h"

void TAvgStat::Add(double x, size_t count) {
    auto guard = Guard(Lock);

    double total = Avg * Count + x;
    Count += count;
    Avg = total / Count;
}

double TAvgStat::GetAndReset() {
    auto guard = Guard(Lock);

    double result = Avg;

    Count = 0;
    Avg = 0;

    return result;
}
