#pragma once

#include "single_stat.h"

#include <util/system/spinlock.h>

class TAvgStat: public ISingleStat {
public:
    TAvgStat(const TString& name)
        : ISingleStat(name)
    {
    }

    void Add(double x, size_t count = 1);

    double GetAndReset() override;

private:
    double Avg = 0;
    size_t Count = 0;

    TAdaptiveLock Lock;
};
