#include "graphite_stats_sink.h"

#include <crypta/lib/native/graphite/utils.h>

#include <util/system/hostname.h>
#include <util/network/socket.h>
#include <util/string/subst.h>
#include <util/stream/str.h>

using namespace NCrypta;

TGraphiteStatsSink::TGraphiteStatsSink(const TString& metricBase, const TString& metricPrefix, const TString& graphiteHost, ui16 graphitePort)
    : MetricBase(metricBase)
    , MetricPrefix(metricPrefix)
    , Hostname(NCrypta::CanonizeGraphiteMetricNode(FQDNHostName()))
    , GraphiteHost(graphiteHost)
    , GraphitePort(graphitePort)
    , Log(NCrypta::NLog::GetLog("graphite"))
{
}

TGraphiteStatsSink::TGraphiteStatsSink(const TGraphiteConfig& config)
    : TGraphiteStatsSink(config.GetRoot(), config.GetPrefix(), config.GetHost(), config.GetPort())
{
}

void TGraphiteStatsSink::WriteStats(const TStatsRegistry::TSnapshot& snapshot, time_t ts) {
    try {
        TSocket socket(TNetworkAddress(GraphiteHost, GraphitePort), TDuration::Seconds(10));

        for (const auto& kvp : snapshot) {
            const auto& graphiteString = MakeGraphiteString(kvp.first, kvp.second, ts) + '\n';
            socket.Send(graphiteString.data(), graphiteString.size());
        }
    } catch (yexception& e) {
        Log->error("Exception: {}", e.what());
    }
}

TString TGraphiteStatsSink::MakeGraphiteString(const TString& metric, double value, time_t ts) const {
    TStringStream ss;

    ss << MetricPrefix << "." << Hostname;

    if (!MetricBase.empty()) {
        ss << "." << MetricBase;
    }

    ss << "." << metric << " " << value << " " << ts;

    return ss.Str();
}
