#pragma once

#include <crypta/lib/native/stats/graphite/proto/graphite_config.pb.h>
#include <crypta/lib/native/stats/stats_sink.h>

#include <crypta/lib/native/log/log.h>

class TGraphiteStatsSink : public IStatsSink {
public:
    explicit TGraphiteStatsSink(const TString& metricBase, const TString& metricPrefix = "one_min", const TString& graphiteHost = "localhost", ui16 graphitePort = 42000);
    explicit TGraphiteStatsSink(const NCrypta::TGraphiteConfig& config);

    void WriteStats(const TStatsRegistry::TSnapshot& snapshot, time_t ts) override;

private:
    TString MakeGraphiteString(const TString& metric, double value, time_t ts) const;

    TString MetricBase;
    TString MetricPrefix;
    TString Hostname;
    TString GraphiteHost;
    ui16 GraphitePort;
    NCrypta::NLog::TLogPtr Log;
};
