#include "log_stats_sink.h"

TLogStatsSink::TLogStatsSink(const TString& name)
    : Log(NCrypta::NLog::GetLog(name))
{
}

void TLogStatsSink::WriteStats(const TStatsRegistry::TSnapshot& snapshot, time_t ts) {
    for (const auto& kvp : snapshot) {
        Log->info("{} {} {}", kvp.first, kvp.second, ts);
    }
}
