#include <iostream>
#include <cmath>
#include <limits>
#include "max_stat.h"

void TMaxStat::Add(double x) {
    auto guard = Guard(Lock);

    Value = std::fmax(Value, x);
}

double TMaxStat::GetAndReset() {
    auto guard = Guard(Lock);

    double result = Value > std::numeric_limits<double>::lowest() ? Value : 0;
    Value = std::numeric_limits<double>::lowest();

    return result;
}
