#include "solomon_stats_sink.h"

#include <library/cpp/http/client/client.h>
#include <library/cpp/http/client/query.h>
#include <library/cpp/monlib/encode/json/json.h>

using namespace NCrypta;

TSolomonStatsSink::TSolomonStatsSink(const TSolomonConfig& config)
    : TSolomonStatsSink(
          config.GetProject(),
          config.GetService(),
          config.GetCluster(),
          config.GetLabels(),
          config.GetSchema(),
          config.GetHost(),
          config.GetPort(),
          config.GetOauthToken()
      )
{}

void TSolomonStatsSink::WriteStats(const TStatsRegistry::TSnapshot& snapshot, time_t ts) {
    try {
        NMonitoring::TMetricRegistry sensorsRegistry(Labels);

        for (const auto& [metric, value] : snapshot) {
            sensorsRegistry.Gauge({{SOLOMON_LABEL_SENSOR, metric}})->Set(value);
        }

        SendSensors(sensorsRegistry, TInstant::Seconds(ts));
    } catch (const yexception& e) {
        Log->error("Exception: {}", e.what());
    }
}

void TSolomonStatsSink::SendSensors(const NMonitoring::TMetricRegistry& sensorsRegistry, const TInstant& ts) const {
    TStringStream ss;

    sensorsRegistry.Accept(ts, NMonitoring::EncoderJson(&ss).Get());

    NHttp::TFetchQuery req(
        SolomonUrl,
        NHttp::TFetchOptions()
            .SetPostData(ss.Str())
            .SetContentType(TString(NMonitoring::NFormatContenType::JSON))
            .SetOAuthToken(OAuthToken.empty() ? Nothing() : MakeMaybe(OAuthToken)));

    const auto& result = NHttp::Fetch(req);

    Y_ENSURE(result->Success(), "Failed to send metrics to Solomon. HTTP " << result->Code << ": " << result->Data);
}
