#pragma once

#include <crypta/lib/native/log/log.h>
#include <crypta/lib/native/stats/solomon/proto/solomon_config.pb.h>
#include <crypta/lib/native/stats/stats_sink.h>
#include <crypta/lib/native/url/url_utils.h>

#include <library/cpp/monlib/metrics/labels.h>
#include <library/cpp/monlib/metrics/metric_registry.h>

#include <util/generic/hash.h>
#include <util/system/hostname.h>

class TSolomonStatsSink: public IStatsSink {
public:
    template <typename TLabelsMap = THashMap<TString, TString>>
    TSolomonStatsSink(
        const TString& project,
        const TString& service,
        const TString& cluster,
        const TLabelsMap& labels = TLabelsMap(),
        const TString& schema = "https",
        const TString& solomonHost = "solomon.yandex.net",
        ui16 solomonPort = 443,
        const TString& oauthToken = "")
        : SolomonUrl(NCrypta::NUrlUtils::MakeUrl(schema, solomonHost, solomonPort, "/api/v2/push", {{SOLOMON_LABEL_PROJECT, project}, {SOLOMON_LABEL_SERVICE, service}, {SOLOMON_LABEL_CLUSTER, cluster}}))
        , OAuthToken(oauthToken)
        , Log(NCrypta::NLog::GetLog("solomon"))
    {
        for (const auto& [key, value] : labels) {
            Labels.Add(key, value);
        }

        Labels.Add(SOLOMON_LABEL_HOST, FQDNHostName()); // Will not overwrite if host is already specified
    }

    explicit TSolomonStatsSink(const NCrypta::TSolomonConfig& config);

    void WriteStats(const TStatsRegistry::TSnapshot& snapshot, time_t ts) override;

private:
    void SendSensors(const NMonitoring::TMetricRegistry& sensorsRegistry, const TInstant& ts) const;

    TString SolomonUrl;
    TString OAuthToken;
    NMonitoring::TLabels Labels;
    NCrypta::NLog::TLogPtr Log;

    static constexpr auto SOLOMON_LABEL_PROJECT = "project";
    static constexpr auto SOLOMON_LABEL_SERVICE = "service";
    static constexpr auto SOLOMON_LABEL_CLUSTER = "cluster";
    static constexpr auto SOLOMON_LABEL_HOST = "host";
    static constexpr auto SOLOMON_LABEL_SENSOR = "sensor";
};
