#pragma once

#include <util/generic/maybe.h>
#include <util/system/spinlock.h>

using TLockType = TAdaptiveLock;
using TGuardType = TGuard<TAdaptiveLock>;

struct TStatLockingPolicy {
    inline TMaybe<TGuardType> Guard() {
        return TMaybe<TGuardType>(::Guard(Lock));
    }

protected:
    TLockType Lock;
};

struct TStatNonLockingPolicy {
    inline TMaybe<TGuardType> Guard() {
        return TMaybe<TGuardType>();
    }
};
