#pragma once

#include "avg_stat.h"
#include "count_stat.h"
#include "hist_stat.h"
#include "max_stat.h"
#include "percentile_stat.h"
#include "stats_registry.h"

#include <util/generic/string.h>
#include <util/generic/vector.h>
#include <util/generic/map.h>
#include <util/generic/ptr.h>
#include <util/system/rwlock.h>

struct TStats {
    struct TSettings {
        double HistMin = 0;
        double HistMax = 3600;
        size_t HistBinCount = 3600;
        i64 PercentMax = 24 * 3600 * 365;
        i32 PercentPrecision = 3;
        TVector<float> Percentiles = {0, 10, 20, 30, 40, 50, 60, 70, 80, 90, 95, 98, 99, 99.9, 100};
    };

    TStatsRegistry::TPtr<TMultiStat<TCountStat>> Count;
    TStatsRegistry::TPtr<TMultiStat<TMaxStat>> Max;
    TStatsRegistry::TPtr<TMultiStat<TAvgStat>> Avg;
    TStatsRegistry::TPtr<TMultiPercentileStat> Percentile;
    TStatsRegistry::TPtr<TMultiHistStat> Hist;

    TStats() = default;
    TStats(const TString& name, const TSettings& settings, TStatsRegistry* statsRegistry = Singleton<TStatsRegistry>());

    static void Register(const TString& name, const TSettings& settings);
    static void RegisterDefault(const TString& name, const TSettings& settings);
    static void Unregister(const TString& name);
    static void UnregisterDefault();
    static void UnregisterAll();
    static TStats& Get(const TString& name);
    static TStats& GetDefault();

private:
    static THashMap<TString, TStats> Stats;
    static THolder<TStats> DefaultStats;

    static TRWMutex Lock;
};
