#include "stats_registry.h"

TStatsRegistry::TSnapshot TStatsRegistry::GetSnapshot() {
    auto guard = Guard(Lock);

    TSnapshot snapshot;

    for (auto& stat : SingleStats) {
        snapshot.insert({stat->GetName(), stat->GetAndReset()});
    }

    for (auto& stat : MapStats) {
        for (const auto& kvp : stat->GetAndReset()) {
            snapshot.insert({stat->GetName() + '.' + kvp.first, kvp.second});
        }
    }

    return snapshot;
}
