#pragma once

#include "single_stat.h"
#include "map_stat.h"
#include "multi_stat.h"

#include <util/generic/vector.h>
#include <util/generic/map.h>
#include <util/generic/ptr.h>
#include <util/generic/yexception.h>
#include <util/system/spinlock.h>

class TStatsRegistry {
public:
    template <typename T>
    using TPtr = TAtomicSharedPtr<T>;

private:
    using TSingleStatPtr = TPtr<ISingleStat>;
    using TMapStatPtr = TPtr<IMapStat>;

public:
    using TSnapshot = TMap<TString, double>;

    template <typename T, typename... TArgs>
    typename std::enable_if_t<std::is_base_of<IMapStat, T>::value, TAtomicSharedPtr<T>> Create(const TArgs&... args) {
        auto guard = Guard(Lock);

        TAtomicSharedPtr<T> ptr(new T(args...));
        MapStats.push_back(ptr);

        return ptr;
    }

    template <typename T, typename... TArgs>
    typename std::enable_if_t<std::is_base_of<ISingleStat, T>::value, TAtomicSharedPtr<T>> Create(const TArgs&... args) {
        auto guard = Guard(Lock);

        TAtomicSharedPtr<T> ptr(new T(args...));
        SingleStats.push_back(ptr);

        return ptr;
    }

    TSnapshot GetSnapshot();

private:
    TVector<TSingleStatPtr> SingleStats;
    TVector<TMapStatPtr> MapStats;

    TAdaptiveLock Lock;
};
