#include "stats_writer.h"

#include <util/system/thread.h>

TStatsWriter::TStatsWriter(TStatsRegistry& statsRegistry, const TDuration& timeout)
    : StatsRegistry(statsRegistry)
    , Runner(timeout, [this](){ WriteStats(); }, "stats-writer") {
}

void TStatsWriter::AddSink(THolder<IStatsSink> sink) {
    TGuard guard(Mutex);
    Sinks.emplace_back(std::move(sink));
}

void TStatsWriter::Start() {
    Runner.Start();
}

void TStatsWriter::WriteStats() {
    TGuard guard(Mutex);

    const auto& snapshot = StatsRegistry.GetSnapshot();
    const time_t ts = time(nullptr);

    for (auto& sink: Sinks) {
        sink->WriteStats(snapshot, ts);
    }
}
