#pragma once

#include "stats_registry.h"
#include "stats_sink.h"

#include <crypta/lib/native/periodic_task/periodic_task.h>

#include <util/datetime/base.h>

class TStatsWriter {
public:
    TStatsWriter(TStatsRegistry& statsRegistry, const TDuration& timeout);

    void AddSink(THolder<IStatsSink> sink);
    void WriteStats();
    void Start();

private:
    TStatsRegistry& StatsRegistry;

    TVector<THolder<IStatsSink>> Sinks;
    TMutex Mutex;

    NCrypta::TPeriodicTask Runner;
};
