#include "stream_stats_sink.h"

TStreamStatsSink::TStreamStatsSink(IOutputStream& stream, const TString& prefix)
    : Stream(stream)
    , Prefix(prefix)
{
}

void TStreamStatsSink::WriteStats(const TStatsRegistry::TSnapshot& snapshot, time_t ts) {
    for (const auto& [key, value] : snapshot) {
        Stream << Prefix << ts << " " << key << " " << value << Endl;
    }
}
