#include "utils.h"

namespace {
    template<typename T>
    TVector<float> GetSortedPercentiles(const T& percentiles) {
        TVector<float> sortedPercentiles;
        std::copy(percentiles.begin(), percentiles.end(), std::back_inserter(sortedPercentiles));
        std::sort(sortedPercentiles.begin(), sortedPercentiles.end());
        return sortedPercentiles;
    }
}

TStats::TSettings GetStatsSettings(const NCrypta::NStats::TStatsConfig& statsConfig) {
    return {
        .HistMin = statsConfig.GetHist().GetMin(),
        .HistMax = statsConfig.GetHist().GetMax(),
        .HistBinCount = statsConfig.GetHist().GetBinCount(),
        .PercentMax = statsConfig.GetPercentile().GetMax(),
        .PercentPrecision = statsConfig.GetPercentile().GetPrecision(),
        .Percentiles = GetSortedPercentiles(statsConfig.GetPercentile().GetPercentiles())
    };
}

THolder<TStatsWriter> GetStatsWriter(TVector<THolder<IStatsSink>>&& sinks) {
    auto* stats = Singleton<TStatsRegistry>();
    auto statsWriter = MakeHolder<TStatsWriter>(*stats, TDuration::Minutes(1));

    for (auto& sink : sinks) {
        statsWriter->AddSink(std::move(sink));
    }

    statsWriter->Start();
    return statsWriter;
}
