#include "case.h"

#include <util/string/ascii.h>
#include <util/string/builder.h>
#include <util/string/split.h>

namespace NCrypta {
    TString ToUpperCamelCase(TStringBuf str) {
        TStringBuilder result;

        auto parts = StringSplitter(str).SplitBySet("-_");

        for (const auto& part : parts) {
            auto word = part.Token();

            if (word.empty()) {
                continue;
            }

            result << AsciiToUpper(word[0]) << word.substr(1);
        }

        return result;
    }
}
