#pragma once

#include <util/generic/string.h>
#include <util/generic/vector.h>

namespace NCrypta::NStringArchive {
    struct TFileInfo {
        TString Name;
        TString Data;

        auto operator<=>(const TFileInfo& other) const = default;
    };

    TString Archive(const TVector<TFileInfo>& files, size_t bufferSize = 1024 * 1024);
    TVector<TFileInfo> Unarchive(const TString& archive);
}
