#include "tcp_options.h"
#include <util/string/hex.h>

namespace NCrypta {
    TTcpOptions::TTcpOptions(TStringBuf options) {
        constexpr static size_t MinIpv4Mtu{576};
        constexpr static size_t MaxOptionsLength = MinIpv4Mtu * 2;
        auto optionsLen = options.size();
        size_t i = 0;

        if (optionsLen % 2) {
            ythrow yexception() << "Options length: " << optionsLen << " incorrect, must be even";
        }

        if (optionsLen > MaxOptionsLength) {
            ythrow yexception() << "Options length: " << optionsLen << " > MaxOptionsLength = " << MaxOptionsLength;
        }

        while (i < optionsLen) {
            auto optionId = String2Byte(options.data() + i);

            if (optionId == ETcpOptions::ENDOFOPTIONLIST) {
                Options.insert({static_cast<ui64>(ETcpOptions::ENDOFOPTIONLIST), {}});
                break;
            }
            if (optionId == ETcpOptions::NOOPERATION) {
                Options.insert({static_cast<ui64>(ETcpOptions::NOOPERATION), {}});
                i += 2;
                continue;
            }

            auto currentLen = String2Byte(options.data() + i + 2);
            if (currentLen < 2 || (i + currentLen * 2) > optionsLen) {
                ythrow yexception() << "Incorrect currentLen: " << options[i+2] << options[i+3];
                return;
            }

            Options[optionId] = TString{options.SubString(i + 4, currentLen * 2 - 4)};
            i += currentLen * 2;
        }
    }

    const TTcpOptions::TOptionsStorage& TTcpOptions::Get() const {
        return Options;
    };

    TMaybe<TTcpOptions> ParseTcpOptions(TStringBuf options) {
        try {
            TTcpOptions result{options};
            return result;
        } catch(...) {
            return Nothing();
        }
    }
}
