#pragma once

#include <util/generic/hash.h>
#include <util/generic/maybe.h>

namespace NCrypta {
class TTcpOptions {
public:
    using TOptionsStorage = THashMap<ui64, TString>;

    enum ETcpOptions {
        ENDOFOPTIONLIST = 0,
        NOOPERATION = 1,
    };

    TTcpOptions(TStringBuf options);
    const TOptionsStorage& Get() const;

private:
    TOptionsStorage Options;
};

TMaybe<TTcpOptions> ParseTcpOptions(TStringBuf options);
}
