#include "../tcp_options.h"

#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(NormalizeIp) {
    using namespace NCrypta;
    using TOptionsStorage = TTcpOptions::TOptionsStorage;

    Y_UNIT_TEST(Empty) {
        UNIT_ASSERT_EQUAL(TTcpOptions("").Get(), (TOptionsStorage{}));
    }

    Y_UNIT_TEST(CorrectWithEndOfOptions) {
        TVector<std::pair<TString, TOptionsStorage>> testCases{
            {"070200", {{0, ""}, {7, ""}}},
            {"070201990200", {{0, ""}, {1, ""}, {7, ""}, {153, ""}}},
            {"0204055003030604022812eab9993f5e5c5e38b37a8d6b97cb2eb50101010101010101010101010100",
            {{0, ""}, {1, ""}, {2, "0550"}, {3, "06"}, {4, ""}, {40, "eab9993f5e5c5e38b37a8d6b97cb2eb5"}}},
        };

        for (const auto& [input, reference] : testCases) {
            TTcpOptions parsed(input);
            UNIT_ASSERT_EQUAL(parsed.Get(), reference);
        }
    }

    Y_UNIT_TEST(CorrectWithoutEndOfOptions) {
        UNIT_ASSERT_EQUAL(TTcpOptions("0702").Get(), (TOptionsStorage{{7, ""}}));
    }

    Y_UNIT_TEST(EarlyExitOnEndOfOptions) {
        UNIT_ASSERT_EQUAL(TTcpOptions("070200990200xx").Get(), (TOptionsStorage{{0, ""}, {7, ""}}));
    }

    Y_UNIT_TEST(IncorrectLength) {
        UNIT_ASSERT_EXCEPTION_CONTAINS(TTcpOptions("070"), yexception, "Options length: 3 incorrect, must be even");
        TString longString(3000, '1');
        UNIT_ASSERT_EXCEPTION_CONTAINS(TTcpOptions(longString), yexception, "Options length: 3000 > MaxOptionsLength = 1152");
    }

    Y_UNIT_TEST(IncorrectOptionLength) {
        UNIT_ASSERT_EXCEPTION_CONTAINS(TTcpOptions("072a"), yexception, "Incorrect currentLen: 2a");
        UNIT_ASSERT_EXCEPTION_CONTAINS(TTcpOptions("07xx"), yexception, "invalid hex character 120");
    }

    Y_UNIT_TEST(IncorrectOptionId) {
        UNIT_ASSERT_EXCEPTION_CONTAINS(TTcpOptions("xx072a"), yexception, "invalid hex character 120");
    }

    Y_UNIT_TEST(ParseTcpOptions) {
        auto correct = ParseTcpOptions("0702");
        UNIT_ASSERT(correct);
        UNIT_ASSERT_EQUAL(correct->Get(), (TOptionsStorage{{7, ""}}));

        auto wrong = ParseTcpOptions("xx");
        UNIT_ASSERT(!wrong);
    }
}
