#include "threaded.h"

#include <util/generic/yexception.h>
#include <util/system/thread.h>

using namespace NCrypta;

TThreaded::TThreaded(const TString& name)
    : Name(name)
{
}

void TThreaded::Start() {
    AtomicSet(Running, 1);

    Thread = SystemThreadFactory()->Run([this] {
        if (Name) {
            TThread::SetCurrentThreadName(Name.data());
        }

        if (AtomicGet(Running)) {
            Run();
        }

        CallOnFinishHandler();

        Stop();
    }).Release();
}

void TThreaded::Stop() {
    AtomicSet(Running, 0);
}

void TThreaded::Join() {
    if (Thread) {
        Thread->Join();
    }
}

void TThreaded::StopAndJoin() {
    Stop();
    Join();
}

bool TThreaded::IsRunning() const {
    return AtomicGet(Running);
}

void TThreaded::SetOnFinishHandler(TOnFinishHandler handler) {
    TGuard guard(OnFinishHandlerMutex);
    OnFinishHandler = handler;
}

void TThreaded::CallOnFinishHandler() {
    TGuard guard(OnFinishHandlerMutex);

    if (OnFinishHandler) {
        OnFinishHandler();
    }
}
