#pragma once

#include <util/generic/ptr.h>
#include <util/generic/string.h>
#include <library/cpp/deprecated/atomic/atomic.h>
#include <util/system/mutex.h>
#include <util/thread/factory.h>

namespace NCrypta {
    class TThreaded : TNonCopyable {
    public:
        using TOnFinishHandler = std::function<void()>;

        explicit TThreaded(const TString& name = "");
        virtual ~TThreaded() = default;  // NOTE: Derived class MUST call StopAndJoin() in derived destructor

        void Start();
        void Stop();
        void Join();
        void StopAndJoin();
        bool IsRunning() const;

        void SetOnFinishHandler(TOnFinishHandler handler);
    private:
        void CallOnFinishHandler();

        virtual void Run() = 0;

        TString Name;
        TAtomic Running = 0;
        TAtomicSharedPtr<IThreadFactory::IThread> Thread;

        TMutex OnFinishHandlerMutex;
        TOnFinishHandler OnFinishHandler;
    };
}
