#pragma once

#include "utils.h"

#include <crypta/lib/native/stats/stats.h>

#include <util/datetime/base.h>
#include <util/system/defaults.h>

namespace NCrypta {
    template <typename T>
    class TScopeTimer {
    public:
        TScopeTimer(TStatsRegistry::TPtr<T>& stat, const TString& name)
            : StartInstant(TInstant::Now())
            , Stat(stat)
            , Name(name)
        {
        }

        TScopeTimer(const TScopeTimer&) = delete;
        TScopeTimer& operator=(const TScopeTimer&) = delete;

        TScopeTimer(TScopeTimer&& other) {
            StartInstant = other.StartInstant;
            Stat = other.Stat;
            other.Stat = nullptr;
            Name = other.Name;
        }

        TScopeTimer& operator=(TScopeTimer&&) = delete;

        ~TScopeTimer() {
            if (Stat) {
                Stat->Add(Name, MusecsTillNow(StartInstant));
            }
        }

    private:
        TInstant StartInstant;
        TStatsRegistry::TPtr<T> Stat;
        TString Name;
    };
}
