#include "shifted_clock.h"

#include <util/string/cast.h>
#include <util/system/env.h>

bool TShiftedClock::IsLate = false;
bool TShiftedClock::IsFrozen = false;
TDuration TShiftedClock::Offset = TDuration::MicroSeconds(0);
TInstant TShiftedClock::FrozenTime;

TInstant TShiftedClock::Now() {
    if (IsFrozen) {
        return FrozenTime;
    }

    return ApplyOffset(TInstant::Now());
}

void TShiftedClock::ResetNow(const TInstant& ut) {
    const TInstant curT = TInstant::Now();
    if (curT < ut) {
        ResetOffsetFast(ut - curT);
    } else {
        ResetOffsetLate(curT - ut);
    }
}

void TShiftedClock::ResetTimestampNow(ui64 timestamp) {
    ResetNow(TInstant::Seconds(timestamp));
}

void TShiftedClock::FreezeTimestamp(ui64 timestamp) {
    IsFrozen = true;
    FrozenTime = TInstant::Seconds(timestamp);
}

void TShiftedClock::FreezeTimestampFromEnv(const TString& env) {
    TString envFrozenTimestampNow = GetEnv(env);
    if (envFrozenTimestampNow) {
        TShiftedClock::FreezeTimestamp(FromString<ui32>(envFrozenTimestampNow));
    }
}

TDuration TShiftedClock::GetOffset() {
    return Offset;
}

TInstant TShiftedClock::ApplyOffset(const TInstant& time) {
    if (IsLate) {
        return time - GetOffset();
    }

    return time + GetOffset();
}

void TShiftedClock::ResetOffsetLate(const TDuration& duration) {
    Offset = duration;
    IsLate = true;
}

void TShiftedClock::ResetOffsetFast(const TDuration& duration) {
    Offset = duration;
    IsLate = false;
}

bool TShiftedClock::Frozen() {
    return IsFrozen;
}
