#pragma once

#include <util/datetime/base.h>
#include <util/generic/string.h>

class TShiftedClock {
public:
    typedef TTimeBase<TInstant>::TValue TValue;

    /// Get shifted Now (or frozen ts if clock is frozen)
    static TInstant Now();

    /// Takes no effect if frozen
    static void ResetTimestampNow(ui64 timestamp);

    /// Intended to be used in unit tests to prevent flapping
    static void FreezeTimestamp(ui64 timestamp);

    static void FreezeTimestampFromEnv(const TString& env = "CRYPTA_FROZEN_TIME");

    static bool Frozen();

private:
    static void ResetNow(const TInstant& ut);

    static TDuration GetOffset();
    static TInstant ApplyOffset(const TInstant& time);

    static void ResetOffsetLate(const TDuration& duration);
    static void ResetOffsetFast(const TDuration& duration);

private:
    // late => clock hours late and true time is greater
    // !late => clock hours hurry and true time is less
    static bool IsLate;
    static TDuration Offset;
    static bool IsFrozen;
    static TInstant FrozenTime;
};
