#include "sleeper.h"

using namespace NCrypta;

TSleeper::TSleeper(const size_t maxNoSleepCycles, const TDuration& maxSleep)
    : MaxNoSleepCycles(maxNoSleepCycles)
    , MaxSleep(maxSleep)
    , CurrSleep(TDuration::Zero())
{
}

void TSleeper::Sleep() {
    if (NoSleepCyclesCount < MaxNoSleepCycles) {
        NoSleepCyclesCount++;
    } else {
        if (CurrSleep < MaxSleep) {
            CurrSleep += TDuration::MicroSeconds(1);
        }

        ::Sleep(CurrSleep);
    }
}

void TSleeper::Wake() {
    NoSleepCyclesCount = 0;
    CurrSleep = TDuration::Zero();
}
