#include "ttl.h"

using namespace NCrypta;

TTtl::TTtl(time_t ttl,  time_t now)
    : Ttl(ttl)
    , Now(now)
{}

bool TTtl::IsExpired(time_t ts) const {
    return Ttl != 0 && (ts + Ttl < Now);
}

void TTtl::Save(IOutputStream* buffer) const {
    ::Save(buffer, Ttl);
    ::Save(buffer, Now);
}

void TTtl::Load(IInputStream* buffer) {
    ::Load(buffer, Ttl);
    ::Load(buffer, Now);
}
