#pragma once

#include <crypta/lib/native/time/shifted_clock.h>

#include <util/ysaveload.h>

namespace NCrypta {
    class TTtl {
    public:
        TTtl(time_t ttl = 0, time_t now = TShiftedClock::Now().Seconds());
        bool IsExpired(time_t ts) const;

        void Save(IOutputStream* buffer) const;
        void Load(IInputStream* buffer);

    private:
        time_t Ttl = 0;
        time_t Now = 0;
    };
}
