#include "create_tvm_client.h"

#include <crypta/lib/native/log/wrappers/tvm/tvm_spdlog_wrapper.h>

#include <library/cpp/tvmauth/checked_user_ticket.h>

namespace {
    using namespace NTvmAuth;

    EBlackboxEnv BbEnvFromString(const TString& env) {
        if (env == "Prod") {
            return EBlackboxEnv::Prod;
        } else if (env == "Test") {
            return EBlackboxEnv::Test;
        } else if (env == "ProdYaTeam") {
            return EBlackboxEnv::ProdYateam;
        } else if (env == "TestYaTeam") {
            return EBlackboxEnv::TestYateam;
        } else if (env == "Stress") {
            return EBlackboxEnv::Stress;
        }

        ythrow yexception() << "Unknown BlackBox environment: " << env;
    }
}

NTvmAuth::TTvmClient NCrypta::CreateTvmClient(const TTvmApiConfig& config) {
    NTvmAuth::TLoggerPtr logger = NTvmAuth::TDevNullLogger::IAmBrave();
    if (config.HasLog()) {
        logger = MakeIntrusive<NLog::TTvmSpdlogWrapper>(config.GetLog());
    }

    NTvmAuth::NTvmApi::TClientSettings settings;
    if (config.HasTvmTestPort()) {
        settings.SetTvmHostPort("localhost", config.GetTvmTestPort());
    }
    settings.SetSelfTvmId(config.GetSelfClientId());
    settings.EnableServiceTicketChecking();

    const auto& userTicketChecking = config.GetUserTicketChecking();
    if (userTicketChecking.GetEnabled()) {
        settings.EnableUserTicketChecking(BbEnvFromString(userTicketChecking.GetBlackBoxEnv()));
    }

    if (!config.GetDestinations().empty()) {
        NTvmAuth::NTvmApi::TClientSettings::TDstMap dstMap;
        for (const auto& [alias, id]: config.GetDestinations()) {
            dstMap[alias] = NTvmAuth::NTvmApi::TClientSettings::TDst(id);
        }
        settings.EnableServiceTicketsFetchOptions(config.GetSecret(), std::move(dstMap));
    }

    return NTvmAuth::TTvmClient(settings, logger);
}
