#include "get_checked_service_ticket.h"

TMaybe<NTvmAuth::TCheckedServiceTicket> NCrypta::GetCheckedServiceTicket(const NTvmAuth::TTvmClient& client, const THttpHeaders& headers) {
    const auto ticketIt = std::find_if(headers.begin(),
                                       headers.end(),
                                       [](const auto& h) { return to_lower(h.Name()) == NCrypta::SERVICE_TICKET_HEADER; });

    if (ticketIt == headers.end()) {
        return Nothing();
    }
    return client.CheckServiceTicket(ticketIt->Value());
}