#include "get_checked_user_ticket.h"

TMaybe<NTvmAuth::TCheckedUserTicket> NCrypta::GetCheckedUserTicket(const NTvmAuth::TTvmClient& client, const THttpHeaders& headers) {
    const auto ticketIt = std::find_if(headers.begin(),
                                       headers.end(),
                                       [](const auto& h) { return to_lower(h.Name()) == NCrypta::USER_TICKET_HEADER; });

    if (ticketIt == headers.end()) {
        return Nothing();
    }
    return client.CheckUserTicket(ticketIt->Value());
}
