#pragma once

#include "headers.h"

#include <library/cpp/http/io/headers.h>
#include <library/cpp/tvmauth/client/facade.h>

#include <util/generic/maybe.h>
#include <util/generic/string.h>

namespace NCrypta {
    template <typename THeaders>
    TMaybe<NTvmAuth::TCheckedUserTicket> GetCheckedUserTicket(const NTvmAuth::TTvmClient& client, const THeaders& headers) {
        const auto& ticketIt = std::find_if(headers.begin(),
                                            headers.end(),
                                            [](const auto& h) {return to_lower(h.first) == USER_TICKET_HEADER; });

        if (ticketIt == headers.end()) {
            return Nothing();
        }
        return client.CheckUserTicket(ticketIt->second);
    }

    TMaybe<NTvmAuth::TCheckedUserTicket> GetCheckedUserTicket(const NTvmAuth::TTvmClient& client, const THttpHeaders& headers);
}
