#include "tvm_status_reporter.h"

using namespace NCrypta;

const TString TTvmStatusReporter::DefaultService = "tvm-client-status";

const auto TTvmStatusReporter::DefaultRetryOptions = TRetryOptions()
    .WithCount(10)
    .WithSleep(TDuration::Seconds(1))
    .WithIncrement(TDuration::Seconds(1));

TTvmStatusReporter::TTvmStatusReporter(
    const NTvmAuth::TTvmClient& tvmClient,
    TJugglerClient& jugglerClient,
    TDuration period,
    TString hostname,
    TString service,
    TRetryOptions retryOptions
)
    : TPeriodicTask(period, [this](){ Report(); }, "TvmStatusReporter", true)
    , TvmClient(tvmClient)
    , JugglerClient(jugglerClient)
    , Hostname(std::move(hostname))
    , Service(std::move(service))
    , RetryOptions(std::move(retryOptions)) {
}

void TTvmStatusReporter::Report() {
    auto report = [status=TvmClient.GetStatus(), this](){
        if (status == NTvmAuth::TClientStatus::Ok) {
            JugglerClient.ReportOk(Hostname, Service, "OK");
        } else {
            TString description(status.GetLastError());
            JugglerClient.ReportWarn(Hostname, Service, description);
        }
    };

    DoWithRetry<std::exception>(report, RetryOptions, false);
}
