#pragma once

#include <crypta/lib/native/juggler/juggler_client.h>
#include <crypta/lib/native/periodic_task/periodic_task.h>

#include <library/cpp/tvmauth/client/facade.h>
#include <library/cpp/retry/retry.h>

#include <util/system/hostname.h>

namespace NCrypta {
    class TTvmStatusReporter : public TPeriodicTask {
    public:
        TTvmStatusReporter(
            const NTvmAuth::TTvmClient& tvmClient,
            TJugglerClient& jugglerClient,
            TDuration period = TDuration::Minutes(1),
            TString hostname = FQDNHostName(),
            TString service = DefaultService,
            TRetryOptions retryOptions = DefaultRetryOptions
        );
    private:
        void Report();

        static const TString DefaultService;
        static const TRetryOptions DefaultRetryOptions;

        const NTvmAuth::TTvmClient& TvmClient;
        TJugglerClient& JugglerClient;
        const TString Hostname;
        const TString Service;
        const TRetryOptions RetryOptions;
    };
}


